(function (ns) {var PasswordStrengthChecker = (function () {
    var checker = null;

    function KasPassCheck() {
        var reasons = maa(5);

        this.tbls = [
            {
                vp: [[0, 0.0866, 0.408, 0.474], [0.0193, 0.413, 0.488, 0.683], [0, 0.106, 0.606, 0.756]],
                sf: [0.0393, 0.0393, 0.0393, 0.0393, 0.0393, 0.0393, 0.0393, 0.0393, 0.0393, 0.0393, 0.0393, 0.0393, 0.0393, 0.0393, 0.0361, 0.0295, 0.0328, 0.0393, 0.0393, 0.0393, 0.0393, 0.0393, 0.0393, 0.0393, 0.0393, 0.0361],
                lf: [[0xc0000200, 0x880a2202, 0xa002002a, 696320, 664064, 0xaa000002, 0x80a02ac0, 10248, 548044800, 35782688, 704643106, 545390754, 33564680, 59944, 8388608, 713687048, 0x80000aa, 0x88008008, 569504, 2, 686293120, 570468874, 2048, 9080320, 0, 548929536, 0x88000002, 0xc008202a, 131874, 545423360, 8915490, 0x82800802, 805838850, 0xa88000c0, 0x82a28000, 33687680, 0x80000088, 772317184, 164002, 663584, 44091400, 526464, 587202560], [0xc0000000, 512, 0, 524288, 0, 536870912, 128, 0, 131072, 0, 0x8000000, 32, 0, 49152, 0, 33554432, 12, 0, 12288, 0, 8388608, 2, 0, 3072, 0, 3145728, 0, 0x80000000, 512, 0, 524288, 0, 536870912, 128, 0, 131072, 0, 0xc000000, 32, 0, 32768, 0, 33554432], [0xc0202000, 525056, 0, 571211776, 0xa0000000, 807411712, 192, 131072, 0x88030200, 0, 0xc080008, 8240, 536870912, 51200, 0x82000802, 50331648, 0x8000888, 557056, 539500704, 2048, 0xc00020, 8388611, 8192, 134144, 0x8800800, 538970112, 32768, 0xe0000000, 2824, 2056, 786432, 524288, 813694976, 139456, 8, 197248, 2050, 0xc0a0000, 33554480, 8388616, 49664, 2, 50331648]]
            },
            {
                vp: [[0.0208, 0.0443, 0.0808, 0.128], [0.0217, 0.0396, 0.0617, 0.0921], [0.0179, 0.0351, 0.0588, 0.0911], [0.0201, 0.0378, 0.0606, 0.0913]],
                sf: [0.0746, 0.0367, 0.0419, 0.0391, 0.0767, 0.0307, 0.029, 0.0354, 0.0546, 0.026, 0.0283, 0.0454, 0.0349, 0.0568, 0.0501, 0.0291, 0.0136, 0.0551, 0.0557, 0.0541, 0.0315, 0.0214, 0.0187, 0.0149, 0.0303, 0.0155],
                lf: [[704676528, 973081256, 0x8228228, 0x8888388, 673316874, 772407426, 0xa8088a80, 44055040, 0x8aa28a2, 0x82280880, 0xcaa2282a, 0x800e0e0a, 8398848, 0x8a8802b0, 704645288, 547522602, 0x8a0e0a0, 0x880a808c, 738992256, 0xa808e8c0, 0x808a0880, 0x88ac8802, 0x80a0002a, 178730, 0x880c0a28, 547530752, 0xaa828222, 0xaaa88c2c, 0x80080a8, 8946304, 0xa0b8008, 0x8c280282, 0xa808aaa8, 0xa2a22a00, 0xa0e0a00, 0x80a000e0, 0xc280282a, 698888, 0x8a2a028, 0xa8a02228, 0xa0088a8, 0x8a2802a, 0xa000000], [0xcac2ca28, 704645802, 0xa2282a0, 0x8a2e0a2, 0xa82a800a, 0xa828ab82, 0xa008cac2, 0x82282f00, 0xb8a0a2a, 0x82a008aa, 0x82a2282a, 698376, 732143624, 0xcaca8a28, 704643754, 598344352, 0x88a8082, 0xb82a808a, 0xa8080b82, 0xa2088a80, 0x82383a00, 0x8ac28aa, 0x82a00882, 0xc08a282a, 567304, 581148672, 0xaaeaa02a, 0xaa80aaac, 673874080, 0x8c8c0c2, 0xa82a800a, 0x8e082b83, 0xa008aaea, 0x8a282a80, 0x8a828a3, 0x83a008a2, 0x8082283a, 9087530, 0xaa82a828, 0xaa82a828, 0xaaa02aaa, 0xaaaa2a0, 0xa000000], [0xcac2c2a8, 713067178, 0xaaa282a0, 0x8aae282, 0xaa2aa08a, 0xaaaaaa82, 0xa008cac2, 0x82a82a80, 0x8aaa2aaa, 0x82b00aaa, 0xaaa2a82a, 9087658, 0xaaa2a008, 0xcac282a8, 713067178, 715817642, 0x8aaaaaa, 0xa82a008a, 0xaea8aa82, 0xa008caca, 0xcaa82a80, 0xaae28aa, 0x82a808ca, 0xc2c2a82a, 0x808aaaa8, 0xaaa2e008, 0xaaaaaaaa, 0xaaaaaaac, 0xa8ab82a0, 0x88ac88a, 0xba3a800a, 0xaeaaab82, 0xa008cac2, 0xc2a82a80, 0x8aaaaaaa, 0x82aa08ab, 0xaa8aaa2b, 9087658, 0xaaaaaa28, 0xaaaaaaa8, 715164330, 0xaaaaaaaa, 704643072], [0xcac08238, 704645806, 682263200, 0x8aae08a, 0xa82a008a, 0xae2aaa82, 0xa0088ac0, 0x82b83a00, 0x8aaa2aaa, 0x82a208aa, 0xeaaa282a, 9088554, 0xa282a008, 0xcac082b8, 973114026, 715784866, 0x8aaa2aa, 673849484, 0xac282282, 0xa008cac2, 0x82a82a80, 0x8aac0822, 0x82a008ca, 0xc082382a, 8956968, 578985992, 0xaaaaaaaa, 0xabaa8cac, 673350304, 0x8cac28a, 0xa82a000a, 0xae28a282, 0xa0088ac0, 0x82b83a80, 0x8aae2aa2, 0x82a80882, 0xc28aa82a, 9087530, 0xaaa2a22a, 0xaaa2aaa8, 715164330, 0xaaaa8aaa, 0xa000000]]
            }
        ];
        this.prob = function (i, j, l) {
            return p(i, j, l, this.tbls[0].lf);
        };
        this.calc = function (t) {
            var rval = 0;
            for (var i = 0; i < this.tbls.length; ++i) {
                var s = Math.max.apply(null, avg(clc(t, this.tbls[i])));
                reasons[i] = (s < 1.5 ? 0 : (s / 1.5));
                rval = Math.max(s, rval);
            }

            var l = lk(t);
            reasons[2] = (l >= 1 ? 0 : 1 / l);
            this.reasons = reasons;
            return rval / (vrs(t) * l);
        };
        this.mkrval = function (r) {
            var rs = maa(5);
            for (var i = 0; i < 5; ++i) rs[i] = [i, reasons[i]];
            rs.sort(function (a, b) {
                if (a[1] < b[1]){ return 1; };
                if (a[1] > b[1]){ return -1; };
                return 0;
            });
            for (var i = 0; i < 5; ++i) rs[i] = rs[i][0];
            return {quality: r, reasons: rs};
        };

        function cc(t, i) {
            return t.charCodeAt(i);
        }

        function _cd(t, i) {
            return cc(t, i) - 97;
        }

        function avg(a) {
            var r = a.p;
            for (var i = 0; i < a.p.length; ++i) r[i] = (a.c[i] != 0 ? r[i] / a.c[i] : 1.5);
            return r;
        }

        function maa(l, f) {
            var a = [];
            for (var k = 0; k < l; k++) a.push(f === undefined ? 0 : f);
            return a;
        }

        function ma(l) {
            return {p: maa(l), c: maa(l)};
        }

        function suma(a, b) {
            var r = a;
            for (var i = 0; i < a.length; ++i) r[i] = a[i] + b[i];
            return r;
        }

        function sum(a, b) {
            return {p: suma(a.p, b.p), c: suma(a.c, b.c)};
        }

        function p(i, j, l, lf) {
            var c = i * 26 + j;
            var b = lf[l][~~(c / 16)];
            return ((b >> (30 - 2 * (c % 16))) & 3);
        }

        function se(i, t, ctx) {
            var c = _cd(t, i);
            var r = ma(ctx.lf.length);
            for (var j = i + 1, l = 0; j < t.length; ++j, ++l) {
                r.p[l] += p(c, _cd(t, j), l, ctx.lf);
                r.c[l]++;
                if (l == (ctx.lf.length - 1)) break;
            }

            return r;
        }

        function prep(t) {
            t = t.toLowerCase();
            return t.replace(/[^a-z]/g, '');
        }

        function clc(t, tbl) {
            t = prep(t);
            var r = ma(tbl.lf.length);
            if (t != '') {
                for (var i = 0; i < t.length; ++i) r = sum(r, se(i, t, tbl))
            }

            return r;
        }

        function cap(a) {
            return cc(a, 0) > 96;
        }

        function ctp(a) {
            var c = cc(a, 0);
            if ((c > 64 && c < 91) || (c > 96 && c < 123)) return 0;
            if (c > 47 && c < 58) return 1;
            return (c > 126 ? 3 : 2)
        }

        function vrq(a, b) {
            var t = ctp(a);
            if (t != ctp(b)) return 0.04;
            if (t == 0 && cap(a) != cap(b)) return 0.01;
            return 0;
        }

        function uni(a) {
            if (a.length <= 1) return a;
            var t = [a[0]], p = a[0];
            for (var i = 1; i < a.length; ++i) {
                if (a[i] != p) {
                    t.push(a[i]);
                    p = a[i];
                }

            }

            return t;
        }

        function dvrs(t) {
            if (t.length <= 1) return 1;
            var d = [], p = cc(t, 0);
            for (var i = 1; i < t.length; ++i) {
                var c = cc(t, i);
                d.push(c - p);
                p = c;
            }

            d.sort();
            var dsz = d.length;
            d = uni(d);
            if (d.length <= 2) return 0.5;
            if (d.length < dsz / 2) return (0.5 + d.length / dsz);
            return 1.1;
        }

        function ovrs(t) {
            if (t.length <= 1) return 1;
            var q = 1;
            var p = t.charAt(0);
            for (var i = 1; i < t.length; ++i) {
                q += vrq(p, t.charAt(i));
                p = t.charAt(i);
            }
            return q;
        }

        function vrs(t) {
            var d = dvrs(t);
            reasons[4] = 1 / d;
            var o = ovrs(t);
            reasons[3] = 1 / o;
            return Math.min(d, o);
        }

        function lk(t) {
            if (t.length <= 0) return 0.01;
            if (t.length >= 80) return Math.log(t.length);
            return Math.log(t.length) / Math.log(11 - (~~(t.length / 10)));
        }
    }

    function retv(v) {
        if (v <= 1) return 0;
        if (v <= 1.5) return 1;
        if (v <= 2) return 2;
        return 3;
    }

    function getPasswordStrength(value) {
        if (!checker) {
            checker = new KasPassCheck();
        }
        var val = retv(checker.calc(value));

        if (val == 3 || val == 2 || value.length >= 8) {
            return checker.mkrval(val);
        }
        checker.reasons[2] = 0;

        return checker.mkrval(2);
    }

    return {
        getPasswordStrength: getPasswordStrength
    };
})();function NeedToShowBalloon(elem){
	if(!elem)return false;
	if(!elem.tagName||elem.tagName.toLowerCase()!="input")return false;
	if(!elem.type||elem.type.toLowerCase()!='password')return false;
	var inputs=document.getElementsByTagName('input');
	var p=-1,pp=-1,f=false;
	function p_near(i,j){
		function r(x){return Math.round(x);}
		function bnd(e){return e.getBoundingClientRect();}
		function hid(p){if (p&&(((p.right-p.left)==0)||((p.top-p.bottom)==0)))return true;return false;}
		function abs(a){return Math.abs(a);}
		var r1=bnd(inputs[i]);
		var r2=bnd(inputs[j]);
		if (hid(r1))return false;
		if (hid(r2))return false;
		var dx=abs(r(r2.left-r1.left));
		var dy=abs(r(r2.top-r1.top));
		var dxw=abs(r(r2.left-r1.right));
		var dyh=abs(r(r2.top-r1.bottom));
		var n=10,m=130;
		if(dy<=n&&dxw<=m)return true;
		if(dy<=m&&dxw<=n)return true;
		if(dx<=n&&dyh<=m)return true;
		if(dx<=m&&dyh<=n)return true;
		return false;
	};
	function in_double_set(i,j)
	{
		if(elem==inputs[i]||elem==inputs[j])return true;
		return false;
	}
	function check_double()
	{
		if(f)
		{
			if(p>=0&&pp>=0&&in_double_set(p,pp))return true;
			f=false;
		}
		p=-1;pp=-1;
		return false;
	}
	for(var i=0;i<inputs.length;++i){
		if(inputs[i].type.toLowerCase()=="password"){
			if (p>=0){
				if(p_near(p,i)){
					if(pp>=0){
						if(in_double_set(i,p))return true;
						p=-1;pp=-1;
					}else{
						if((i==inputs.length-1)&&(in_double_set(i,p)))return true;
						f=true;
					}
				}else{
					if(check_double())return true;
				}
				pp=p;
			}
			p=i;
		}else{
			if(check_double())return true;
		}
	}
	return false;
}
ns.CheckPasswordStrength = PasswordStrengthChecker.getPasswordStrength;
ns.NeedToShowBalloon = NeedToShowBalloon;

}) (KasperskyLab || {});